/*
 * This source code has been downloaded from
 * http://eegeek.net/content/view/27/32/1/4/ on 15.11.2007
 * where it is/was made available under the
 * Creative Commons Attribution-Noncommercial-Share Alike 2.5 License.
 */

using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using PVOID = System.IntPtr;
using DWORD = System.UInt32;

namespace usb_api
{
	unsafe public class usb_interface
	{
		#region  String Definitions of Pipes and VID_PID
		public string vid_pid_boot= "vid_04d8&pid_000b";    // Bootloader vid_pid ID
		public string vid_pid_norm= "vid_04d8&pid_000c";

		protected string out_pipe= "\\MCHP_EP1"; // Define End Points
		protected string in_pipe= "\\MCHP_EP1";
        protected string in_pipe_async = "\\MCHP_EP1_ASYNC";
		#endregion

		#region Imported DLL functions from mpusbapi.dll
		[DllImport("mpusbapi.dll")]
		private static extern DWORD _MPUSBGetDLLVersion();
		[DllImport("mpusbapi.dll")]
		private static extern DWORD _MPUSBGetDeviceCount(string pVID_PID);
		[DllImport("mpusbapi.dll")]
		protected static extern void* _MPUSBOpen(DWORD instance,string pVID_PID,string pEP,DWORD dwDir,DWORD dwReserved);
		[DllImport("mpusbapi.dll")]
		protected static extern DWORD _MPUSBRead(void* handle,void* pData,DWORD dwLen,DWORD* pLength,DWORD dwMilliseconds);
		[DllImport("mpusbapi.dll")]
		private static extern DWORD _MPUSBWrite(void* handle,void* pData,DWORD dwLen,DWORD* pLength,DWORD dwMilliseconds);
		[DllImport("mpusbapi.dll")]
        private static extern DWORD _MPUSBReadInt(void* handle, void* pData, DWORD dwLen, DWORD* pLength, DWORD dwMilliseconds);
		[DllImport("mpusbapi.dll")]
		private static extern bool _MPUSBClose(void* handle);
		#endregion

		protected void* myOutPipe;
		protected void* myInPipe;
        protected void* myAsyncInPipe;

        protected bool prvPipesOpen;
        public bool PipesOpen
        {
            get { return prvPipesOpen; }
            set { }
        }

        public enum Commands : byte
        {
            UPDATE_LED = 0x32,
            RESET = 0xFF
        }

		protected virtual void OpenPipes()
		{
			DWORD selection=0; // Selects the device to connect to
			myOutPipe = _MPUSBOpen(selection,vid_pid_norm,out_pipe,0,0);
			myInPipe = _MPUSBOpen(selection,vid_pid_norm,in_pipe,1,0);
            prvPipesOpen = true;
		}

        public usb_interface()
        {
            prvPipesOpen = false;
        }

		public void ClosePipes()
		{
			_MPUSBClose(myOutPipe);
            _MPUSBClose(myAsyncInPipe);
			_MPUSBClose(myInPipe);
            prvPipesOpen = false;
		}

        /// <summary>
        /// Writes one packet to PIC, receives response packet.
        /// </summary>
        /// <param name="SendData">Pointer to bytes to be sent</param>
        /// <param name="SendLength">Number of bytes to be sent</param>
        /// <param name="ReceiveData">Pointer to location for received data</param>
        /// <param name="ReceiveLength">Expected number of received bytes</param>
        /// <returns>1=Success, 2=Incorrect RX Length, 3=Read Failed</returns>
		protected DWORD SendReceivePacket(byte* SendData, DWORD SendLength, byte* ReceiveData, DWORD *ReceiveLength)
		{
            if (prvPipesOpen==false)
                OpenPipes();
            uint SendDelay = 1000;
            uint ReceiveDelay = 1000;
            DWORD rval = 0;
            DWORD SentDataLength;
            DWORD ExpectedReceiveLength = *ReceiveLength;
            if (_MPUSBWrite(myOutPipe, (void*)SendData, SendLength, &SentDataLength, SendDelay) == 1)
            {

                if (_MPUSBRead(myInPipe, (void*)ReceiveData, ExpectedReceiveLength, ReceiveLength, ReceiveDelay) == 1)
                {
                    if (*ReceiveLength == ExpectedReceiveLength)
                    {
                        rval = 1;   // Success!
                    }
                    else if (*ReceiveLength < ExpectedReceiveLength)
                    {
                        rval = 2;   // Partially failed, incorrect receive length
                    }
                }
                else
                {
                    rval = 3;   //Read Failed
                }
            }
            return rval;
		}

		public DWORD GetDLLVersion()
		{
			return _MPUSBGetDLLVersion();
		}
		public DWORD GetDeviceCount(string Vid_Pid)
		{
			return _MPUSBGetDeviceCount(Vid_Pid);
		}

        /// <summary>
        /// Simple method for sending/receiving USB data from the PIC.
        /// </summary>
        /// <param name="Command">Command byte</param>
        /// <param name="rxlength">Expected length of received packet</param>
        /// <param name="data">Array of bytes to send after command - pass null if not applicable</param>
        /// <param name="dataout">Array for received bytes</param>
        /// <returns>1=Success, 2=Incorrect RX Length, 3=Read Failed</returns>
        public uint EasyCommand(byte Command, int rxlength, byte[] data, out byte[] dataout)
        {            
            byte* send_buf = stackalloc byte[64];
            byte* receive_buf = stackalloc byte[64];
            DWORD RecvLength;
            uint rval;

            RecvLength = (DWORD)rxlength;
            send_buf[0] = Command;
            if (data != null)
            {
                for (int i = 0; i < data.Length; i++)
                { send_buf[i + 1] = data[i]; }
            }
            else
                data = new byte[] { }; //just set to empty array so .Length member is valid at 0.
            rval = SendReceivePacket(send_buf, 1 + (uint)data.Length, receive_buf, &RecvLength);
            if (rval != 1)
            { dataout = null; return rval; }
            dataout = new byte[rxlength];
            for (int i = 0; i < rxlength; i++)
            { dataout[i] = receive_buf[i]; }
            return 1;
        }
	}
}
