/*
 * This source code has been downloaded from
 * http://eegeek.net/content/view/27/32/1/4/ on 15.11.2007
 * where it is/was made available under the
 * Creative Commons Attribution-Noncommercial-Share Alike 2.5 License.
 * 
 * 08.01.2008 Steffen Schtte: Added autoDownload property
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using usb_api;
using HEXReader;

namespace USBBL
{
    public partial class Bootloader : Form
    {
        usb_interface pic = new usb_interface();
        VirtualPIC vpic;
        StreamReader hex;
        HexInterpreter hexint;
        Bootloader_Interface bli;
        bool autoDownload;


        public Bootloader()
        {
            InitializeComponent();
        }

        private void Bootloader_Load(object sender, EventArgs e)
        {

        }

        private void button3_Click(object sender, EventArgs e)
        {
            OpenFileDialog o = new OpenFileDialog();
            o.Filter = "HEX files (*.hex)|*.hex|All files (*.*)|*.*";
            if (o.ShowDialog() == DialogResult.OK)
            {
                LoadHexFile(o.FileName);
            }
        }

        public void ShowAndLoad(string hexFile, bool autoDownload)
        {
            this.autoDownload = autoDownload;
            checkBoxAutoDownLoad.Checked = autoDownload;
            this.Show();
            LoadHexFile(hexFile);
        }

        private void LoadHexFile(string hexFile)
        {
            textBox1.Clear();
            textBox2.Clear();

            hex = new StreamReader(hexFile);
            while (!hex.EndOfStream)
            {
                textBox1.AppendText(hex.ReadLine() + "\r\n");
            }
            hex.Close();

            hexint = new HexInterpreter(hexFile);
            vpic = new VirtualPIC(VirtualPIC.ChipType.PIC18F4550);
            hexint.ReadHEX(vpic);
            textBox2.AppendText(vpic.ToString());
            if (hexint.IsValid)
                label3.Text = "HEX Open Succeeded";
            else
                label3.Text = "Errors opening HEX";
            hex.Close();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (pic.GetDeviceCount(pic.vid_pid_boot) > 0)
            {
                timer1.Interval = 5000;
                label1.Text = "PIC detected in BOOT mode";
                button1.Enabled = true;
                button2.Enabled = true;
                button4.Enabled = true;
                button5.Enabled = true;
                if (autoDownload && checkBoxAutoDownLoad.Checked)
                {
                    button1.PerformClick();
                    checkBoxAutoDownLoad.Checked = false;
                }
            }
            else if (pic.GetDeviceCount(pic.vid_pid_norm) > 0)
            {
                timer1.Interval = 1000;
                label1.Text = "PIC detected in USER mode";
                button1.Enabled = false;
                button2.Enabled = false;
                button4.Enabled = false;
                button5.Enabled = false;
            }
            else
            {
                timer1.Interval = 1000;
                label1.Text = "No PIC detected";
                button1.Enabled = false;
                button2.Enabled = false;
                button4.Enabled = false;
                button5.Enabled = false;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            label3.Text = "Programming...";
            this.Refresh();
            if(bli==null)
                bli = new Bootloader_Interface();
            if(hexint!=null)
            {
                uint rval = bli.Write(ref vpic);
                if (rval == 1)
                    label3.Text = "Success";
                else
                    label3.Text = "Write Error, Code: " + rval.ToString();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            label3.Text = "Erasing...";
            if(bli==null)
                bli = new Bootloader_Interface();
            vpic = new VirtualPIC(VirtualPIC.ChipType.PIC18F4550);
            if (bli.Erase(vpic) == 1)
                label3.Text = "Erased!";
            else
                label3.Text = "Erase Failed";
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if(bli==null)
                bli = new Bootloader_Interface();
            vpic = new VirtualPIC(VirtualPIC.ChipType.PIC18F4550);
            label3.Text = "Reading...";
            textBox1.Clear();
            textBox2.Clear();
            uint rval = bli.Read(ref vpic);
            if (rval != 1)
                MessageBox.Show(rval.ToString());
            textBox2.AppendText(vpic.ToString());
            label3.Text = "Read Complete";
        }

        private void button5_Click(object sender, EventArgs e)
        {
            if(bli==null)
                bli = new Bootloader_Interface();
            bli.Execute();
        }

        private void button6_Click(object sender, EventArgs e)
        {
            SaveFileDialog o = new SaveFileDialog();
            o.Filter = "HEX files (*.hex)|*.hex|All files (*.*)|*.*";
            if (o.ShowDialog() == DialogResult.OK)
            {
                hexint = new HexInterpreter(o.FileName);
                hexint.WriteHEX(vpic);
            }
            label3.Text = "HEX file saved";
        }

        private void checkBoxAutoDownLoad_CheckedChanged(object sender, EventArgs e)
        {
            this.autoDownload = checkBoxAutoDownLoad.Checked;
        }
    }
}