﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Objects
{
    class Variable : VisualObject
    {

        public Variable(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }

        public override bool IsObject()
        {
            return true;
        }

    
        #region IObject Member

        public override  string Read()
        {
            return ModelElement.Name;
        }

        public override string Write(string source)
        {
            return ModelElement.Name.Replace(" ", "_") + " = " + source;
        }

        #endregion
    }
}
