﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Objects
{
    class PWMOut : VisualElement, IObject
    {

        public PWMOut(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }



        #region IObject Member

        public string Read()
        {
            throw new Exception("PWMout cannot be read from.");
        }

        public string Write(string source)
        {
            return "\tSetDCPWM1(" + source + ")";
        }

        #endregion

        public override bool IsObject()
        {
            return true;
        }

    
    }
}
