﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Objects
{
    /// <summary>
    /// 
    /// </summary>
    class Constant : VisualElement, IObject
    {


        public Constant(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }

        #region IObject Member

        public string Read()
        {
            string constantValue = ModelElement.GetTaggedValueAsString("VisualPIC(18F4550)", "ConstantTags", "Value");

            return constantValue;
        }

        public string Write(string source)
        {
            throw new Exception("A Constant cannot be written to: " + ToString());
        }

        #endregion

        public override bool IsObject()
        {
            return true;
        }

      
    }
}
