﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;
using StarUML_PICAddIn.codeGen;

namespace StarUML_PICAddIn.codeGen.Objects
{
    class BitIn : VisualObject
    {

        public BitIn(IUMLModelElement modelElement) : base(modelElement)
        {

        }

 

        #region IObject Member

        public override string Read()
        {
            string port = ModelElement.GetTaggedValueAsString("VisualPIC(18F4550)", "BitInOutTags", "Port");
            string pin = ModelElement.GetTaggedValueAsString("VisualPIC(18F4550)", "BitInOutTags", "Pin");

            return "PORT" + port + "bits.R" + port + pin;
        }

        public override string Write(string source)
        {
            throw new Exception("A BitIn port cannot be written to: " + ToString());
        }

        #endregion
    }
}
