﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace StarUML_PICAddIn.codeGen
{
    internal class DirectedTransition
    {
        private VisualElement successor;

        private string guardCondition;


        public DirectedTransition(VisualElement successor, string guardCondition)
        {
            this.successor = successor;
            this.guardCondition = guardCondition;
        }


        internal VisualElement Successor
        {
            get { return successor; }
        }

        internal string GuardCondition
        {
            get { return guardCondition; }
        }

        public bool IsGuardConditionTrue()
        {
            return guardCondition.ToLowerInvariant().Equals("true");
        }
    }
}
