﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Activities
{
    abstract class VisualActivity : VisualElement, IActivity
    {
        private bool hasBeenGenerated = false;

        protected uint MAX_SUCCESSORS = 1;
        protected uint MIN_SUCCESSORS = 0;

        public VisualActivity(IUMLModelElement modelElement):base(modelElement)
        {

        }

        public override bool IsObject()
        {
            return false;
        }

        #region IActivity Member

        /// <summary>
        /// Generates the code.
        /// 
        /// Template method
        /// </summary>
        /// <param name="code">The code.</param>
        public void GenerateCode(StringBuilder code)
        {
            if (!hasBeenGenerated)
            {
                hasBeenGenerated = true;
                code.AppendLine(this.ModelElement.Name.Replace(" ", "_") + ":");
                GenerateThisCode(code);


                //Maximal one successor activity -> single threaded
                if (CheckSuccessorActivities(MIN_SUCCESSORS, MAX_SUCCESSORS))
                {
                    //Generate code for successor activities
                    foreach (DirectedTransition t in this.Successors)
                    {
                        if (!t.Successor.IsObject())
                        {
                            ((IActivity)t.Successor).GenerateCode(code);
                        }
                    }
                }
            }
            else
            {
                //If the code can not be generated here (because it has been generated elsewhere) jump to it...
                code.Append("goto " + this.ModelElement.Name.Replace(" ", "_") + ";");
            }
        }

        /// <summary>
        /// Generates the this code.
        /// 
        /// Hook-Method
        /// </summary>
        /// <param name="code">The code.</param>
        protected abstract void GenerateThisCode(StringBuilder code);
        
        

        #endregion

      
    }
}
