﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;
using StarUML_PICAddIn.codeGen.Objects;

namespace StarUML_PICAddIn.codeGen.Activities
{
    class GreaterZero : VisualActivity
    {
        public GreaterZero(IUMLModelElement modelElement)
            : base(modelElement)
        {
            MAX_SUCCESSORS = 2;
            MIN_SUCCESSORS = 0;
        }

        public override bool IsObject()
        {
            return false;
        }

        /// <summary>
        /// Generates the code for checking if an object is greater zero.
        /// </summary>
        /// <param name="code">The code.</param>
        protected override void GenerateThisCode(StringBuilder code)
        {
            //Exactly one consumed object
            if (CheckConsumed(1, 1))
            {
                IObject objectToCompare = (IObject)ConsumedObjects[0];

                
                code.AppendLine("if (" + objectToCompare.Read() + " > 0)");
                code.AppendLine("{");
                code.AppendLine(GenerateTrueBranch());
                code.AppendLine("}\nelse\n{");
                code.AppendLine(GenerateFalseBranch());
                code.AppendLine("}");
            }
          
        }

        private string GenerateFalseBranch()
        {
            foreach (DirectedTransition t in this.Successors)
            {
                if(t.GuardCondition.ToLowerInvariant().Equals("false"))
                {
                    return "goto " + t.Successor.ModelElement.Name.Replace(" ", "_") + ";";
                }
            }
            return "";
        }

        private string GenerateTrueBranch()
        {
            foreach (DirectedTransition t in this.Successors)
            {
                if (t.GuardCondition.ToLowerInvariant().Equals("true"))
                {
                    return "goto " + t.Successor.ModelElement.Name.Replace(" ", "_") + ";";
                }
            }
            return "";
        }

        
    }
}
