﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Activities
{
    class FlowStart :VisualActivity
    {
        public FlowStart(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }

        /// <summary>
        /// Generates the code.
        /// </summary>
        /// <param name="code">The code.</param>
        protected override void GenerateThisCode(StringBuilder code)
        {
            if (Successors.Count == 0)
            {
                throw new Exception("The Flowstart Activity has no successor.");
            }
            else if (Successors.Count == 1)
            {
                code.AppendLine("\t//Start of the program flow");
            }
            else
            {
                throw new Exception("The Flowstart Activity has more than one successor.");
            }
        }

       
    }
}
