﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;

namespace StarUML_PICAddIn.codeGen.Activities
{
    class Delay : VisualActivity
    {
        public Delay(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }

        /// <summary>
        /// Generates the code.
        /// </summary>
        /// <param name="code">The code.</param>
        protected override void GenerateThisCode(StringBuilder code)
        {
            string delay = ModelElement.GetTaggedValueAsString("VisualPIC(18F4550)", "DelayTags", "Delay(ms)");

            try
            {
                // (12 * 1000 * 4)/48000000Hz = 0.001Sek
                //Where 4 is the number of clocks per cycle and 1000 is the # of cycles delay caused by the method below
                int delayMs = int.Parse(delay) * 12;

                code.AppendLine("\tDelay1KTCYx(" + delayMs + ");");
            }
            catch(Exception)
            {
                CreationProtocol.GetInstance().AddMessage(MessageType.Error, "Cannot convert parameter 'Delay(ms)' to a number: " + delay);
            }
        }

        public override bool IsObject()
        {
            return false;
        }
    }
}
