﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;
using StarUML_PICAddIn.codeGen.Objects;

namespace StarUML_PICAddIn.codeGen.Activities
{
    class Assignment : VisualActivity
    {
        public Assignment(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }

        /// <summary>
        /// Generates the code.
        /// </summary>
        /// <param name="code">The code.</param>
        protected override void GenerateThisCode(StringBuilder code)
        {
            //Exactly one consumed object
            if (CheckConsumed(1, 1))
            {
                //Assign the incoming object to all outgoing objects
                foreach(VisualElement outgoingObject in ProducedObjects)
                {
                    IObject inVal = (IObject)ConsumedObjects[0];
                    IObject outVal = (IObject)outgoingObject;

                    code.AppendLine("\t//Assigning '" + inVal.ToString() + "' to '" + outVal.ToString() + "'");

                    code.Append("\t" + outVal.Write(inVal.Read()));
                    code.AppendLine(";");

                    //Todo: check the datatypes/ranges
                }
            }
        }

        public override bool IsObject()
        {
            return false;
        }
    }
}
