﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;
using StarUML_PICAddIn.codeGen.Objects;

namespace StarUML_PICAddIn.codeGen.Activities
{
    class Addition : VisualActivity
    {
        public Addition(IUMLModelElement modelElement)
            : base(modelElement)
        {

        }


        public override bool IsObject()
        {
            return false;
        }

        /// <summary>
        /// Generates the code for adding up N input values
        /// and assigning it to an output value.
        /// </summary>
        /// <param name="code">The code.</param>
        protected override void GenerateThisCode(StringBuilder code)
        {
            StringBuilder summation = new StringBuilder();

            //At least 2 consumed and exactly one produced objct
            if (CheckConsumed(2, int.MaxValue) && CheckProduced(1, 1))
            {
                int num = ConsumedObjects.Count;
                for (int i = 0; i < num; i++)
                {
                    IObject summand = (IObject)ConsumedObjects[i];
                    summation.Append(summand.Read());
                    if (i < num - 1)
                    {
                        summation.Append(" + ");
                    }
                }
                code.AppendLine("\t"+((IObject)ProducedObjects[0]).Write(summation.ToString()) + ";");
            }
            
        }
 
    }
}
