﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using StarUML;
using System.IO;
using System.Windows.Forms;

namespace StarUML_PICAddIn
{
    internal class VisualApplicationCreator
    {

        public void CreateApplication(IStarUMLApplication starUML, DirectoryInfo projectPath)
        {
            //Creation protocol
            CreationProtocol protocol = CreationProtocol.GetNewInstance();
            

            //Copy framework files if not existing
            ProjectManager pm = new ProjectManager(projectPath);
            pm.CopyFramework();

            //Create the code
            VisualCodeGenerator codeGen = new VisualCodeGenerator(starUML);
            string initCode = codeGen.GenerateInit();
            string includeCode = codeGen.GenerateIncludes();
            string globalVarCde = codeGen.GenerateGlobalVars();
            string loopCode = codeGen.GenerateLoop();

            //Create generated c file with generated code
            pm.InjectGeneratedIncludes(includeCode);
            pm.InjectGeneratedInit(initCode);
            pm.InjectGeneratedGlobals(globalVarCde);
            pm.InjectGeneratedLoop(loopCode);
            
            //Stop process if there are errors
            if (!protocol.HasErorrs)
            {
                //Start on the compiler
                C18Compiler compiler = new C18Compiler();
                DirectoryInfo compPath = new DirectoryInfo((string)starUML.GetOptionValue("VisualPIC", "C18_PATH"));
                DirectoryInfo linkerPath = new DirectoryInfo((string)starUML.GetOptionValue("VisualPIC", "LINKER_PATH"));
                DirectoryInfo libPath = new DirectoryInfo((string)starUML.GetOptionValue("VisualPIC", "LIB_PATH"));

                string hexFile = pm.TargetPath.ToString() + "\\application.hex";

                new FileInfo(hexFile).Delete();
                
                string compilerOutput = compiler.CompileAndLinkApplication(pm.TargetPath, compPath, linkerPath, libPath);

                if(new FileInfo(hexFile).Exists)
                {

                    //Download the program to the PIC
                    bool starBootloader = (bool)starUML.GetOptionValue("VisualPIC", "START_BOOTLOADER");
                    if (starBootloader)
                    {
                        USBBootloader bootloader = new USBBootloader();
                        bool autoDownload = (bool)starUML.GetOptionValue("VisualPIC", "AUTODOWNLOAD");
                        bootloader.Programm(hexFile, autoDownload);
                    }
                }
                else
                {
                    MessageBox.Show("No HEX-File. Maybe the compilation failed?\n\n" + compilerOutput, "Error");
                }
            }
            else
            {
                MessageBox.Show(protocol.GetProtocol(), "Visual PIC Build Protocol");
            }
        }
    }
}
