﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace StarUML_PICAddIn
{
    internal class ProjectManager
    {
        private DirectoryInfo targetPath;

        public DirectoryInfo TargetPath
        {
            get { return targetPath; }
        }

        public ProjectManager(DirectoryInfo projectPath)
        {
            //Create target path
            targetPath = new DirectoryInfo(projectPath.ToString() + "\\uCApp");
            targetPath.Create();
        }

        /// <summary>
        /// Copies the framework files required for the microcontroller project.
        /// </summary>
        internal void CopyFramework()
        {
            //Get source path
            DirectoryInfo frameworkPath = new DirectoryInfo(new DirectoryInfo(Application.ExecutablePath).Parent.FullName + "\\modules\\visualPIC\\uCFiles\\pic18F4550");

           
            //Copy contained files
            FileInfo[] files = frameworkPath.GetFiles();
            for(int i=0; i<files.Length;i++)
            {
                File.Copy(files[i].FullName, targetPath + "\\" + files[i].Name, true);
            }
        }

        /// <summary>
        /// Injects the generated includes.
        /// </summary>
        /// <param name="loopCode">The loop code.</param>
        internal void InjectGeneratedIncludes(string includes)
        {
            InjectGeneratedCode(includes, "/*VisualPIC_CodeInjectionPoint_INCLUDE*/");
        }

        /// <summary>
        /// Injects the generated loop code.
        /// </summary>
        /// <param name="codeToInject">The code to inject.</param>
        internal void InjectGeneratedLoop(string loopCode)
        {
            InjectGeneratedCode(loopCode, "/*VisualPIC_CodeInjectionPoint_LOOP*/");
        }

        /// <summary>
        /// Injects the generated init code.
        /// </summary>
        /// <param name="codeToInject">The code to inject.</param>
        internal void InjectGeneratedInit(string initCode)
        {
            InjectGeneratedCode(initCode, "/*VisualPIC_CodeInjectionPoint_INIT*/");
        }


        private void InjectGeneratedCode(string codeToInject, string injectionPoint)
        {
            string sourceFile = targetPath + "\\generated.c";

            StreamReader reader = new StreamReader(sourceFile);
            StringBuilder source = new StringBuilder();
            string line;
            while ((line = reader.ReadLine()) != null)
            {
                source.AppendLine(line);
                if (line.Contains(injectionPoint))
                {
                    source.AppendLine(codeToInject);
                    source.AppendLine("\t/*END OF VisualPIC_CodeInjectionPoint*/");
                }
            }
            reader.Close();

            StreamWriter writer = new StreamWriter(sourceFile);
            writer.Write(source);
            writer.Close();
        }

        internal void InjectGeneratedGlobals(string globalVarCde)
        {
            InjectGeneratedCode(globalVarCde, "/*VisualPIC_CodeInjectionPoint_GLOBALVARS*/");
        }

    }
}
