﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace StarUML_PICAddIn
{
    public enum MessageType
    {
        Info,
        Warning,
        Error
    }


    /// <summary>
    /// Singleton class for log messages.
    /// </summary>
    internal class CreationProtocol
    {
        private StringBuilder protocol = new StringBuilder();

        private bool hasErorrs = false;

        public bool HasErorrs
        {
            get { return hasErorrs; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CreationProtocol"/> class.
        /// Private->Singleton
        /// </summary>
        private CreationProtocol()
        {
        }

        private static CreationProtocol instance = null;

        internal static CreationProtocol GetInstance()
        {
            if(instance == null)
            {
                instance = new CreationProtocol();
            }
            return instance;
        }

        /// <summary>
        /// Gets a new isntance. Not a classical signelton method
        /// but rewuired for creating a new protocol class when code generation starts.
        /// </summary>
        /// <returns></returns>
        internal static CreationProtocol GetNewInstance()
        {
            instance = new CreationProtocol();
            return instance;
        }

        public string GetProtocol()
        {
            return protocol.ToString();
        }

        public void AddMessage(MessageType type, string message)
        {
            protocol.Append(type.ToString());
            protocol.Append(": ");
            protocol.AppendLine(message);

            if (type == MessageType.Error)
            {
                hasErorrs = true;
            }
        }


       
    }
}
