﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace StarUML_PICAddIn
{
    internal class C18Compiler
    {

        internal void CleanOutput(DirectoryInfo sourcePath)
        {
            System.Diagnostics.Process proc; // Declare New Process
            System.Diagnostics.ProcessStartInfo procInfo = new System.Diagnostics.ProcessStartInfo(); // Declare New Process Starting Information

            procInfo.UseShellExecute = false;
            procInfo.RedirectStandardOutput = true;

            procInfo.WorkingDirectory = sourcePath.ToString();
            procInfo.FileName = sourcePath.ToString() + "\\CleanUp.bat"; // Program or Command to Execute.
            procInfo.Arguments = sourcePath.ToString();

            proc = System.Diagnostics.Process.Start(procInfo);
            proc.WaitForExit(); // Waits for the process to end. (ie. when user closes it down)

        }

        internal string CompileAndLinkApplication(DirectoryInfo sourcePath, DirectoryInfo compPath, DirectoryInfo linkerPath, DirectoryInfo libPath)
        {
            System.Diagnostics.Process proc; // Declare New Process
            System.Diagnostics.ProcessStartInfo procInfo = new System.Diagnostics.ProcessStartInfo(); // Declare New Process Starting Information

            procInfo.UseShellExecute = false;
            procInfo.RedirectStandardOutput = true;

            procInfo.WorkingDirectory = sourcePath.ToString(); 
            procInfo.FileName = sourcePath.ToString() + "\\BuildAll.bat"; // Program or Command to Execute.
            procInfo.Arguments = compPath + " " + linkerPath + " " + libPath; //Command line arguments.
          
            proc = System.Diagnostics.Process.Start(procInfo); 
            proc.WaitForExit(); // Waits for the process to end. (ie. when user closes it down)

            StreamReader reader = proc.StandardOutput;
            string processOutput = reader.ReadToEnd();

            reader.Close();
            proc.Close();

            //Idea: Check for successful build by comparing the old with the new hexfile date

            return processOutput;
        }

        
    }
}
