﻿/*
 * This source code has been originally downloaded from
 * www.steffenschuette.de where it is/was made available under the license:
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 Germany
 * 
 * If you want to modify and redistribute your code please add your name 
 * and changes here:
 * 
 * Date         Author            Change
 * 14.02.2008 | Steffen Schütte | Initial version
 */

using System;
using System.Collections.Generic;
using System.Text;

using StarUML;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;

namespace StarUML_PICAddIn
{

    [ProgId("PICAddIn.PICAddInObj")]
    public class PICAddin : IStarUMLAddIn
    {
                      
        private string msg;


        public PICAddin()
        {
            
        }

               

        #region IStarUMLAddIn Member
        
        public void DoMenuAction(int ActionID)
        {
            try
            {
                IStarUMLApplication starUML = null;

                switch (ActionID)
                {
                    case 1:
                        try
                        {
                            //Get application
                            starUML = Activator.CreateInstance(Type.GetTypeFromProgID("StarUML.StarUMLApplication")) as StarUMLApplication;


                            //Get project path
                            string fileName = starUML.ProjectManager.FileName;
                            //Check if project has been saved
                            if (fileName == null || fileName.Length == 0)
                            {
                                SaveFileDialog dlg = new SaveFileDialog();
                                dlg.Title = "Save As";
                                dlg.Filter = "StarUML Project File(*.uml)|*.uml";
                                DialogResult res = dlg.ShowDialog();

                                if (res == DialogResult.OK)
                                {
                                    //Save the project to get a path
                                    starUML.ProjectManager.SaveProjectAs(dlg.FileName);
                                    fileName = starUML.ProjectManager.FileName;
                                }
                            }

                            if (fileName != null)
                            {
                                //Check for whitespaces
                                DirectoryInfo projectPath = new DirectoryInfo(new DirectoryInfo(fileName).Parent.FullName);

                                if (projectPath.ToString().IndexOf(" ") == -1)
                                {
                                    VisualApplicationCreator creator = new VisualApplicationCreator();
                                    creator.CreateApplication(starUML, projectPath);
                                }
                                else
                                {
                                    MessageBox.Show("Path must not contain whitespaces! (not supported by the C18 compiler)");
                                }
                            }
                            else
                            {
                                MessageBox.Show("Could not save the project!");
                            }
                        }
                        catch (Exception ex)
                        {
                            throw ex;
                        }
                        finally
                        {
                            if(starUML != null)
                            {
                                Marshal.ReleaseComObject(starUML);
                                starUML = null;
                                GC.Collect();
                            }
                        }

                        break;
                    case 2:
                        USBBootloader bootloader = new USBBootloader();
                        bootloader.Show();
                        break;

                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("The following error occurred:\n"+ex.Message, "Error");
            }

                                  

        }

        public void FinalizeAddIn()
        {
        
        }

        public void InitializeAddIn()
        {

        }

        #endregion


        private void ElaborateNamespace(int level, IUMLNamespace namespc)
        {
            msg += "\n" + level + ": " + namespc.Name;
            for (int i = 0; i < namespc.GetOwnedDiagramCount(); i++)
            {
                ElaborateDiagram(namespc.GetOwnedDiagramAt(i));
            }
            for (int i = 0; i < namespc.GetOwnedElementCount(); i++)
            {
                if (namespc.GetOwnedElementAt(i).IsKindOf("UMLNamespace"))
                {
                    ElaborateNamespace(level + 1, (IUMLNamespace)namespc.GetOwnedElementAt(i));
                }
                else
                {
                    msg += "\n" + level + ": " + namespc.GetOwnedElementAt(i).Name;
                }
            }
            for (int i = 0; i < namespc.GetBehaviorCount(); i++)
            {
                ElaborateBehaviour(level +1, namespc.GetBehaviorAt(i));
            }

        }

        private void ElaborateBehaviour(int level, IUMLStateMachine stateMachine)
        {
            for (int i = 0; i < stateMachine.GetTransitionCount(); i++)
            {
                IUMLTransition t = stateMachine.GetTransitionAt(i);
                msg += "\n" + level + ": " + t.Source.Name;
            } 
        }


        private void ElaborateDiagram(IDiagram diagram)
        {
            msg += "\n" + diagram.Name;

        }
    }
}
