using System;
using System.Collections.Generic;
using System.Text;

namespace UltrasonicUSBRadar
{
    

    class TargetInfo
    {
        public uint antennaPosition = 0;

        private IDictionary<uint, uint> targets;

        /// <summary>
        /// Gets or sets the targets.
        /// 
        /// The index represents the clockwise degree
        /// with 0 pointing to the top/front.
        /// The content is the distance in cm.
        /// </summary>
        /// <value>The targets.</value>
        public IDictionary<uint, uint> Targets
        {
            get
            {
                return targets;
            }
        }

        private IDictionary<uint, uint> environment;

        /// <summary>
        /// Gets or sets the environment. These are the 
        /// static distances in all directions.
        /// If a distance is shorter it must be an intruder.
        /// </summary>
        /// <value>The environment.</value>
        public IDictionary<uint, uint> Environment
        {
            get { return environment; }
        }

        public TargetInfo()
        {
            this.targets = new Dictionary<uint, uint>();
            this.environment = new Dictionary<uint, uint>();
            this.targetingRange = new Dictionary<uint, uint>();

            
        }

        private KeyValuePair<uint, uint> activeTarget = new KeyValuePair<uint,uint>(uint.MaxValue, uint.MaxValue);

        public KeyValuePair<uint, uint> ActiveTarget
        {
            get { return activeTarget; }
            set { activeTarget = value; }
        }

        private IDictionary<uint, uint> targetingRange;

        public IDictionary<uint, uint> TargetingRange
        {
            get { return targetingRange; }
        }


        private uint detectionTolerance = 20;

        public uint DetectionTolerance
        {
            get { return detectionTolerance; }
            set { detectionTolerance = value; }
        }

        private uint detectionRange = 180;

        public uint DetectionRange
        {
            get { return detectionRange; }
            set { detectionRange = value; }
        }


        private uint detectionOffset = 0;

        public uint DetectionOffset
        {
            get { return detectionOffset; }
            set { detectionOffset = value; }
        }



        public void CreateEnvironmentFormTargets()
        {
            Environment.Clear();
            foreach (KeyValuePair<uint, uint> kvp in Targets)
            {
                Environment.Add(kvp.Key, kvp.Value);
            }

            //Now calculate the missing degree values
            uint lastDegree = 0;
            for (uint i = 0; i < 360; i++)
            {
                if (environment.ContainsKey(i)
                    && i != lastDegree)
                {
                    //Interpolate the distance from  lastDegree to i
                    if (environment.ContainsKey(lastDegree))
                    {
                        int distance1 = (int)environment[lastDegree];
                        int distance2 = (int)environment[i];

                        float increment = ((float)(distance2 - distance1) / (float)(i - lastDegree));

                        for (uint j = lastDegree + 1; j < i; j++)
                        {
                            environment[j] = (uint)(distance1 + increment * (j - lastDegree));
                        }
                    }
                    lastDegree = i;
                }
            }
        }

        public void CreateDetectionRangeFromEnvironment()
        {

            //Now create the detection range
            TargetingRange.Clear();
            foreach (KeyValuePair<uint, uint> kvp in Environment)
            {
                uint distance = 0;
                if (kvp.Value > detectionTolerance)
                {
                    distance = kvp.Value - detectionTolerance;
                }
                TargetingRange.Add(kvp.Key, distance);
            }
        }
    }
}
