﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using LittleNet.UsbMissile;

namespace UltrasonicUSBRadar
{
    class MissileController
    {
        public delegate void LauncherMessage_EventHandler(string msg);
        public event LauncherMessage_EventHandler LauncherMessage_Event;

        public delegate void LauncherDisarmed_EventHandler();
        public event LauncherDisarmed_EventHandler LauncherDisarmed_Event;

        private bool missileArmed = false;

        public bool LauncherArmed
        {
            get { return missileArmed; }
            set { missileArmed = value; }
        }

        private uint missilesAvailable = 0;

        public uint MissilesAvailable
        {
            get { return missilesAvailable; }
        }

        private int direction = 0; //Direction of the launcher in degrees

        public int LauncherDirection
        {
            get { return direction; }
        }

        private float degreePerSecond = 1;

        public float DegrePerSecond
        {
            get { return degreePerSecond; }
            set { degreePerSecond = value; }
        }

        private bool launcherConnected = false;

        public bool LauncherConnected
        {
            get { return launcherConnected; }
            set { launcherConnected = value; }
        }


        private bool destroyTarget = false;
        private bool resetLauncher = false;
        private uint targetDirection = 0;

        private MissileDevice launcher;

        private Thread targetingThread;

        public Thread TargetingThread
        {
            get { return targetingThread; }
        }

        private TargetInfo targetInfo;

        public MissileController(TargetInfo targetInfo)
        {
            launcher = new MissileDevice();

            targetingThread = new Thread(new ThreadStart(Targeting));
            targetingThread.Start();

            this.targetInfo = targetInfo;
        }

        public void StopTheLaunch()
        {
            destroyTarget = false;
        }

        public void Launch(uint degree)
        {
            destroyTarget = true;

            //Calculate target direction relative to offset
            targetDirection = degree;
        }



        internal void Arm()
        {
            LauncherArmed = true;
            missilesAvailable = 3;

            //Anehmen, das werfer an falscher position ist
            direction = (int)(targetInfo.DetectionRange + targetInfo.DetectionOffset);
            resetLauncher = true;
        }


        internal void Dismantle()
        {
            LauncherArmed = false;

        }

        private void Command(DeviceCommand deviceCommand)
        {
            if(launcherConnected && LauncherArmed)
            {
                launcher.Command(deviceCommand);
            }
        }

        private void CommandAlways(DeviceCommand deviceCommand)
        {
            if (launcherConnected)
            {
                launcher.Command(deviceCommand);
            }
        }

        public bool IsLauncherConnected()
        {
            try
            {
                launcher.Command(DeviceCommand.Stop);
                LauncherMessage_Event("Launcher detected.");
            }
            catch (Exception)
            {

                return false;
            }
            return true;
        }

                  

        public void Targeting()
        {
            while (true)
            {
                if (destroyTarget && !resetLauncher)
                {
                    //If the launcher is in position: Fire at will
                    if (Math.Abs(direction - targetDirection) <= 1)
                    {
                        //This is when it all comes down to a single moment of fear and destruction
                        Command(DeviceCommand.Fire);
                        missilesAvailable--;
                        destroyTarget = false;
                        //Wait some seconds befor starting another attack
                        Thread.Sleep(8000);
                        LauncherMessage_Event("Launcher fired! " + missilesAvailable + " missiles left. Reloading now....");
                        //LauncherMessage_Event(targetDirection +" "+ direction);

                        if(missilesAvailable == 0)
                        {
                            resetLauncher = true;
                            LauncherDisarmed_Event();
                            LauncherMessage_Event(missilesAvailable + " missiles left. Launcher disarmed.");
                        }
                    }
                    else
                    {
                        //Turn one degree to the left
                        if ((int)(direction - targetDirection) < -1)
                        {
                            Command(DeviceCommand.Right);
                            Thread.Sleep((int)(2 / degreePerSecond * 1000));
                            direction+=2;
                        }
                        else if (direction - targetDirection > 1)
                        {
                            Command(DeviceCommand.Left);
                            Thread.Sleep((int)(2 / degreePerSecond * 1000));
                            direction-=2;
                        }
                        else
                        {
                            Command(DeviceCommand.Stop);
                        }
                    }
                }
                else if (resetLauncher && LauncherArmed)
                {
                    uint resetDirection = targetInfo.DetectionOffset;
                    if (direction > resetDirection)
                    {
                        LauncherMessage_Event("Resetting launcher position...");

                        Command(DeviceCommand.Left);
                        Thread.Sleep((int)(2 / degreePerSecond * 1000));
                        direction-=2;
                    }
                    else
                    {
                        resetLauncher = false;
                        Command(DeviceCommand.Stop);
                        LauncherMessage_Event("Launcher ready...");
                    }

                }
                else
                {
                    resetLauncher = false;
                    Command(DeviceCommand.Stop);
                }

                Thread.Sleep(50);
            }
        }


        internal void LauncherDown()
        {
            CommandAlways(DeviceCommand.Down);
        }
       

        internal void LauncherUp()
        {
            CommandAlways(DeviceCommand.Up);
        }

        internal void LauncherStop()
        {
            CommandAlways(DeviceCommand.Stop);
        }

        internal void Fire()
        {
            CommandAlways(DeviceCommand.Fire);
        }

        internal void LauncherRight()
        {
            CommandAlways(DeviceCommand.Right);
        }

        internal void LauncherLeft()
        {
            CommandAlways(DeviceCommand.Left);
        }
    }
}
