
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Drawing.Drawing2D;

namespace UltrasonicUSBRadar
{
	/// <summary>
	/// Summary description for UserControl1.
    /// 
    /// 
	/// </summary>
	public class RadarScreen : System.Windows.Forms.Control
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;


        const float PI = 3.141592654F;

        //Optimized drawing
        private bool drawBackground = false;
        private Bitmap background;

        private TargetInfo targetInfo;
        
        internal TargetInfo TargetInfo
        {
            get
            {
                return targetInfo;
            }
            set
            {
                targetInfo = value;
                this.Refresh();
            }
        }

		public RadarScreen()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
		}

        protected override void OnResize(EventArgs e)
        {
            drawBackground = true;
            this.Refresh();
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.SuspendLayout();
            // 
            // ZzzzRangeBar
            // 
            this.Name = "radarScreen";
            this.Size = new System.Drawing.Size(445, 237);
            this.ResumeLayout(false);

		}
		#endregion

        protected override void OnPaintBackground(PaintEventArgs e)
        {
            //base.OnPaintBackground(e);
        }


        protected override void OnPaint(PaintEventArgs e)
        {
            e.Graphics.SmoothingMode = SmoothingMode.AntiAlias;
            e.Graphics.PixelOffsetMode = PixelOffsetMode.HighQuality;

            Graphics g = e.Graphics;

            int h = this.Height;
            int w = this.Width;
            int diameter = Math.Min(h, w);

            Point center = new Point(diameter / 2, diameter / 2);

            Pen gridPen = new Pen(Color.Green, 1);

            //Draw the background if necessary
            if (drawBackground)
            {
                background = new Bitmap(Width, Height, e.Graphics);
                Graphics ggr = Graphics.FromImage(background);

                drawBackground = false;
                ggr.FillRectangle(new SolidBrush(BackColor), ClientRectangle);

                Pen screenPen = new Pen(Color.Green, 3);
                Brush screenBrush = new SolidBrush(Color.DarkGreen);

                //Draw the screen
                ggr.FillEllipse(screenBrush, 0, 0, diameter, diameter);
                ggr.DrawEllipse(screenPen, 0, 0, diameter, diameter);

                for (int i = 0; i < diameter; i += diameter / 3)
                {
                    ggr.DrawEllipse(gridPen, center.X - i / 2, center.Y - i / 2, i, i);
                }
                e.Graphics.DrawImageUnscaled(background, 0, 0);
            }
            else
            {
                //Use the old background
                e.Graphics.DrawImageUnscaled(background, 0, 0);
            }

           
            if (targetInfo != null)
            {
                //Draw the targets backwards, starting form the antenna position
                for (int i = 110; i < 360; i++)
                {
                    uint position = (targetInfo.antennaPosition - 1 + (uint)i) % 360;
                    int alpha = Math.Max(i - 104, 0); //Old items are more transparent
                    if (targetInfo.Targets.ContainsKey(position))
                    {
                        //Get the distance in cm
                        uint distance = targetInfo.Targets[position];
                        float distanceFactor = (float)distance / 300;

                        float fRadSec = position * PI / 180;

                        float x = center.X + ((float)diameter * distanceFactor / 2 * (float)System.Math.Sin(fRadSec));
                        float y = center.Y - ((float)diameter * distanceFactor / 2 * (float)System.Math.Cos(fRadSec));

                        Color targetColor;

                        if (alpha == 0)
                        {
                            targetColor = Color.DarkGreen;
                        }
                        else
                        {
                            targetColor = Color.FromArgb(alpha, Color.YellowGreen);
                        }

                        g.DrawEllipse(new Pen(targetColor, 2), (int)x, (int)y, 5, 5);
                    }
                }

                {
                    //Draw the antenna position
                    float fRadSec = targetInfo.antennaPosition * PI / 180;

                    float x = center.X + ((float)diameter / 2 * (float)System.Math.Sin(fRadSec));
                    float y = center.Y - ((float)diameter / 2 * (float)System.Math.Cos(fRadSec));

                    g.DrawLine(new Pen(Color.YellowGreen, 2), center.X, center.Y, (int)x, (int)y);
                }

            }

            //Draw the grid
            for (float deg = 0; deg < 360; deg += 22.5f)
            {
                float fRadSec = deg * PI / 180;

                float x = center.X + ((float)diameter / 2 * (float)System.Math.Sin(fRadSec));
                float y = center.Y - ((float)diameter / 2 * (float)System.Math.Cos(fRadSec));

                g.DrawLine(gridPen, center, new Point((int)x, (int)y));
            }
        }

		
	}
}
