using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using usb_api;

namespace UltrasonicUSBRadar
{
    public partial class Form1 : Form
    {
        private usb_interface usbi;

        private PICAsyncManager pam;

        private TargetInfo targets = new TargetInfo();

        private uint antennaPosition = 0;

        public Form1()
        {
            InitializeComponent();

            pam = new PICAsyncManager();

            usbi = new usb_interface();

            this.Controls.Add(pam);
            pam.EventNewUSBIntData += new NewUSBIntDataEventHandler(pam_EventNewUSBIntData);

            radarScreen1.TargetInfo = targets;
        }

      


        private void buttonStartStop_Click(object sender, EventArgs e)
        {

            if (!pam.IsRunning)
            {
                pam.Start();
                toolStripStatusLabel1.Text = "Interrupt monitor thread started...";
                buttonStartStop.Text = "Stop";
            }
            else
            {
                pam.Stop();
                toolStripStatusLabel1.Text = "Interrupt monitor thread stopped...";
                buttonStartStop.Text = "Start";
            }
        }

        /// <summary>
        /// New data has been received from the pic.
        /// </summary>
        /// <param name="e">The <see cref="usb_api.NewUSBIntDataEventArgs"/> instance containing the event data.</param>
        void pam_EventNewUSBIntData(NewUSBIntDataEventArgs e)
        {
            try
            {
                for (int i = 0; i <= 3; i += 3)
                {
                    float stepsPerDegree = float.Parse(degPerStepsTextBox.Text);

                    //Get antenna position
                    antennaPosition = (uint)(e.newdata[i] * 7.5);

                    //Get 8 byte values
                    byte dataL = e.newdata[i + 1];
                    byte dataH = e.newdata[i + 2];

                    //Create 16bit value
                    uint data = dataL + (uint)(256 * dataH);

                    //21,248 uS = 1 tick
                    //Now data is the number of elapsed uS
                    data = (uint)((double)data * 21.248);

                    //Now get the distance in cm (see SRF04 datasheet)
                    data = data / 58;

                    //Console.WriteLine(dataL + ":" + dataH + " = " + data);


                    //Update the data for the given antenna position or create it
                    if (!targets.Targets.ContainsKey(antennaPosition))
                    {
                        targets.Targets.Add(antennaPosition, data);
                    }
                    else
                    {
                        targets.Targets[antennaPosition] = data;
                    }


                }
                targets.antennaPosition = antennaPosition;

                //Redraw the radar screen
                radarScreen1.Refresh();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                buttonStartStop.PerformClick();
            }
        }

        /// <summary>
        /// Sets the number of steps to do into the pic
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void setStepsButton_Click(object sender, EventArgs e)
        {
            byte numberOfSteps = (byte)numOfStepsNumericUpDown.Value;

            byte[] temp = new byte[1];
            byte[] temp2;
            usbi.EasyCommand(0x33, 1, new byte[] { numberOfSteps }, out temp2);
        }

    }
}