﻿/**
 *  This project is licensed by Steffen Schütte with the German version of the
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 License unless
 * stated otherwise.
 *
 * What this means for you using this work is stated at: 
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.0/de/deed.en
 * 
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;


namespace de.steffenschuette.DeBagger
{
    public partial class Form1 : Form
    {
        private bool fistConnection = true;
        private DeBagger deBagger;
        

        public Form1()
        {
            InitializeComponent();
            timer1.Start();
            deBagger = new DeBagger();

        }

        private void beendenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void buttonWrite_Click(object sender, EventArgs e)
        {
            if (!deBagger.WriteConfig())
            {
                MessageBox.Show("Could not write configuration.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        

        private void buttonRead_Click(object sender, EventArgs e)
        {
            if(deBagger.ReadConfig())
            {
                label_numOfDips.Text = deBagger.numOfDips.ToString();
                label_sugar.Text = deBagger.numOfSugar.ToString();
                UpdateTimeLabels(deBagger.secondsToCount);
            }
            else
            {
                MessageBox.Show("Could not read configuration.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }


        /**
         *  Check connection state by qerying the version.
         *  The CPU load based color is transmitted also, if selected.
         */
        private void timer1_Tick(object sender, EventArgs e)
        {
            //Test connection to PIC
            if (!deBagger.ReadState())
            {
                toolStripModeLabel.Text = "Mode: ?";
                toolStripStatusLabel1.Text = "Status: not connected";
                toolStripStatusLabel1.BackColor = Color.Red;
                toolStripStatusLabelTemperature.Text = "Temperature: ?°C";
                fistConnection = true;
            }
            else
            {
                toolStripModeLabel.Text = "Mode: " + deBagger.state.ToString();
                toolStripStatusLabel1.Text = "Status: connected";
                toolStripStatusLabel1.BackColor = Color.Green;
                if(fistConnection)
                {
                    //Read configuration if connection is established first time
                    buttonRead.PerformClick();
                    fistConnection = false;
                }
                toolStripStatusLabelTemperature.Text = "Temperature: " + deBagger.temperature + "°C";

                makeToolStripMenuItem.Enabled = deBagger.state == DeBagger.TEA_STATE.READY;
                pictureBox_ready.Visible = deBagger.state== DeBagger.TEA_STATE.READY;
                pictureBox_steeping.Visible = deBagger.state == DeBagger.TEA_STATE.COUNTING || deBagger.state == DeBagger.TEA_STATE.INSERTING;
                pictureBox_dipping.Visible = deBagger.state == DeBagger.TEA_STATE.DIPPING;
                pictureBox_disposing.Visible = deBagger.state == DeBagger.TEA_STATE.DISPOSING || deBagger.state == DeBagger.TEA_STATE.LIFTING;

                
                if(deBagger.state == DeBagger.TEA_STATE.READY)
                {
                    pictureBox_startStop.Image = Resource1.startButton;
                    UpdateTimeLabels(deBagger.secondsToCount);
                    label_numOfDips.Text = deBagger.numOfDips.ToString();
                }
                else
                {
                    pictureBox_startStop.Image = Resource1.stopButton;
                }

                if (deBagger.state == DeBagger.TEA_STATE.COUNTING)
                {
                    UpdateTimeLabels(deBagger.secondsRemaining);
                }
                else if (deBagger.state == DeBagger.TEA_STATE.DIPPING)
                {
                    UpdateTimeLabels(deBagger.secondsRemaining);
                    label_numOfDips.Text = deBagger.numOfDips - deBagger.dipsDone/2 + "";
                }
                else if (deBagger.state == DeBagger.TEA_STATE.SUGARING)
                {
                    label_sugar.Text = deBagger.numOfSugar - deBagger.sugarDone / 2 + "";
                }
                else if (deBagger.state == DeBagger.TEA_STATE.DISPOSING)
                {
                    UpdateTimeLabels(deBagger.secondsRemaining);
                    label_numOfDips.Text = deBagger.numOfDips - deBagger.dipsDone / 2 + "";
                    label_sugar.Text = deBagger.numOfSugar - deBagger.sugarDone / 2 + "";
                }




                

            }
        }

        private void label_sec_MouseClick(object sender, MouseEventArgs e)
        {
            if (deBagger.state != de.steffenschuette.DeBagger.DeBagger.TEA_STATE.READY)
            {
                MessageBox.Show(this, "Values can only be changed when not making tea!", "Info");
                return;
            }

            uint limit = 60 * 10;

            if (e.Button == MouseButtons.Left)
            {
                deBagger.secondsToCount+=10;
                if (deBagger.secondsToCount > limit)
                {
                    deBagger.secondsToCount = limit;
                }
            }
            else
            {
                if (deBagger.secondsToCount > 19)
                {
                    deBagger.secondsToCount-=10;
                }
            }

            UpdateTimeLabels(deBagger.secondsToCount);
        }

      

        private void label_min_MouseClick(object sender, MouseEventArgs e)
        {
            if (deBagger.state != de.steffenschuette.DeBagger.DeBagger.TEA_STATE.READY)
            {
                MessageBox.Show(this, "Values can only be changed when not making tea!", "Info");
                return;
            }

            uint limit = 60 * 10;

            if (e.Button == MouseButtons.Left)
            {
                deBagger.secondsToCount+=60;
                if (deBagger.secondsToCount > limit)
                {
                    deBagger.secondsToCount = limit;
                }
            }
            else
            {
                if (deBagger.secondsToCount > 69)
                {
                    deBagger.secondsToCount = deBagger.secondsToCount - 60;
                }
            }

            UpdateTimeLabels(deBagger.secondsToCount);
        }

        private void UpdateTimeLabels(uint p)
        {
            label_sec.Text = String.Format("{0:00}", p % 60);
            label_min.Text = String.Format("{0}", p / 60);
        }

        private void label_numOfDips_MouseClick(object sender, MouseEventArgs e)
        {
            if (deBagger.state != de.steffenschuette.DeBagger.DeBagger.TEA_STATE.READY)
            {
                MessageBox.Show(this, "Values can only be changed when not making tea!", "Info");
                return;
            }

            if (e.Button == MouseButtons.Left)
            {
                deBagger.numOfDips++;
                if (deBagger.numOfDips > 5)
                {
                    deBagger.numOfDips = 5;
                }
            }
            else
            {
                if (deBagger.numOfDips > 0)
                {
                    deBagger.numOfDips--;
                }
            }

            label_numOfDips.Text = deBagger.numOfDips.ToString();
        }

     

        private void pictureBox_startStop_Click(object sender, EventArgs e)
        {
            if (deBagger.state != de.steffenschuette.DeBagger.DeBagger.TEA_STATE.READY)
                deBagger.Stop();
            else
                deBagger.Start();
        }

        private void makeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox_startStop_Click(null, null);
        }

        private void label_sugar_MouseClick(object sender, MouseEventArgs e)
        {
            if (deBagger.state != de.steffenschuette.DeBagger.DeBagger.TEA_STATE.READY)
            {
                MessageBox.Show(this, "Values can only be changed when not making tea!", "Info");
                return;
            }

            if (e.Button == MouseButtons.Left)
            {
                deBagger.numOfSugar++;
                if (deBagger.numOfSugar > 3)
                {
                    deBagger.numOfSugar = 3;
                }
            }
            else
            {
                if (deBagger.numOfSugar > 0)
                {
                    deBagger.numOfSugar--;
                }
            }

            label_sugar.Text = deBagger.numOfSugar.ToString();
        }

        private void pictureBox2_Click(object sender, EventArgs e)
        {
            if (deBagger.state == DeBagger.TEA_STATE.READY)
            {
                deBagger.sugar();
            }
            else
            {
                MessageBox.Show(this, "Dispensing sugar is only possible when tea is ready.", "Info");
            }

        }

     


        
      
    }

  

   

}