﻿/**
 *  This project is licensed by Steffen Schütte with the German version of the
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 License unless
 * stated otherwise.
 *
 * What this means for you using this work is stated at: 
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.0/de/deed.en
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace de.steffenschuette.DeBagger
{
    internal class DeBagger
    {
        private usb_api.usb_interface usbInterface = new usb_api.usb_interface();

        public enum TEA_STATE
        {
            READY     = 0,
            COUNTING  = 1,
            LIFTING   = 2,
            DIPPING   = 3,
            INSERTING = 4,
            DISPOSING = 5,
            SUGARING = 6
        }


        //State values
        public bool connected = false;
        public TEA_STATE state = TEA_STATE.READY;
        public double temperature = 0;

        //Config values
        public uint numOfDips = 1; //0=disabled
        public uint numOfSugar = 1;
        public uint dipsDone = 0;
        public uint sugarDone = 0;
        public uint secondsToCount = 5 * 60;
        public uint secondsRemaining = 0;


        public bool WriteConfig()
        {
            byte[] data = new byte[4];

            data[0] = (byte)(secondsToCount/255);
            data[1] = (byte)(secondsToCount%255);
            data[2] = (byte)(numOfDips);
            data[3] = (byte)(numOfSugar);

            //Write Data to PIC
            byte[] result;
            usbInterface.EasyCommand(0x01, 1, data, out result);
            if (result == null)
            {
                return false;
            }
            return true;
        }



        public bool ReadConfig()
        {
            //Read Data from PIC
            byte[] result;
            usbInterface.EasyCommand(0x02, 5, new byte[1], out result);
            if (result == null)
                return false;

            secondsToCount = (uint)(result[1] * 255 + result[2]);
            numOfDips = result[3];
            numOfSugar = result[4];
                        

            return true;
        }

        public bool ReadState()
        {
            byte[] result;
            byte[] data = new byte[11];

            usbInterface.EasyCommand(0x00, 11, data, out result);
            if (result == null)
            {
                connected = false;
            }
            else
            {
                connected = true;
                state = (TEA_STATE)Enum.ToObject(typeof(TEA_STATE), result[1]);
                temperature = ((double)result[2]) / 2;
                
                uint secondsToCount = (uint)(255 * result[3] + result[4]);
                uint elapsedTime = (uint)(255 * result[5] + result[6]);
                secondsRemaining = secondsToCount - elapsedTime;
                //numOfDips = result[7];
                dipsDone = result[8];
                //numOfSugar = result[9];
                sugarDone = result[10];
            }
            return connected;
        }


        internal void Stop()
        {
            byte[] data = new byte[1];
            //Write Data to PIC
            byte[] result;
            usbInterface.EasyCommand(0x03, 1, data, out result);
        }

        internal void Start()
        {
            byte[] data = new byte[4];
            data[0] = (byte)(secondsToCount / 255);
            data[1] = (byte)(secondsToCount % 255);
            data[2] = (byte)(numOfDips);
            data[3] = (byte)(numOfSugar);

            //Write Data to PIC
            byte[] result;
            usbInterface.EasyCommand(0x04, 1, data, out result);
        }

        internal void sugar()
        {
            byte[] data = new byte[1];
            data[0] = (byte)(numOfSugar);

            //Write Data to PIC
            byte[] result;
            usbInterface.EasyCommand(0x05, 1, data, out result);
        }
    }
}
