/*********************************************************************
 * This project is thus licensed with the German version of the
 * Creative Commons Attribution-Noncommercial-Share Alike 2.0 License.
 * 
 * What this means for you using this work is stated at: 
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.0/de/deed.en
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Steffen Schtte      01/28/2010    
 ********************************************************************/

#ifndef PICDEM_FS_DEMO_H
#define PICDEM_FS_DEMO_H

/** I N C L U D E S **********************************************************/
#include "system\typedefs.h"

/** D E F I N I T I O N S ****************************************************/
/* PICDEM FS USB Demo Version */
#define MINOR_VERSION   0x00    //Demo Version 1.00
#define MAJOR_VERSION   0x01




/** S T R U C T U R E S ******************************************************/
typedef union DATA_PACKET
{
    byte _byte[USBGEN_EP_SIZE];  //For byte access
    word _word[USBGEN_EP_SIZE/2];//For word access(USBGEN_EP_SIZE msut be even)
    struct
    {
        enum
        {
            STATE_UPDATE    = 0x00,
            SET_CONFIG		= 0x01,
			GET_CONFIG 		= 0x02,
			STOP 			= 0x03,
			START 			= 0x04,
			SUGAR           = 0x05,
            RESET           = 0xFF
        }CMD;
        byte len;
    };
    struct
    {
        unsigned :8;
        byte ID;
    };
    struct
    {
        unsigned :8;
        byte led_num;
        byte led_status;
    };
    struct
    {
        unsigned :8;
        word word_data;
    };
} DATA_PACKET;

/** P U B L I C  P R O T O T Y P E S *****************************************/
void UserInit(void);
void ProcessIO(void);
void ProcessUSBIO(void);


#endif //PICDEM_FS_DEMO_H
