'''
Created on 25.11.2010

@author: sschuette
'''

from ctypes import *

from ctypes.wintypes import *

#Bootloader vid_pid ID
vid_pid_boot= "vid_04d8&pid_000b";
vid_pid_norm= "vid_04d8&pid_000c";

#Define End Points
out_pipe= "\\MCHP_EP1"; 
in_pipe= "\\MCHP_EP1";

class USBApi(object):

    def __init__(self):
        # Load DLL into memory.
        self.usbDll = CDLL ("debagger/mpusbapi.dll")

        print "Device count = " + str(self.usbDll._MPUSBGetDeviceCount(vid_pid_norm))
        print "DLL Version = " + str(self.usbDll._MPUSBGetDLLVersion())

    def open_pipes(self):
        selection=0 #Selects the device to connect to, in this example it is assumed you will only have one device per vid_pid connected.
        self.myOutPipe = self.usbDll._MPUSBOpen(selection, vid_pid_norm, out_pipe, 0, 0);
        self.myInPipe = self.usbDll._MPUSBOpen(selection, vid_pid_norm, in_pipe, 1, 0);
    
    def close_pipes(self):
        self.usbDll._MPUSBClose(self.myOutPipe);
        self.usbDll._MPUSBClose(self.myInPipe);
    
    def send_packet(self, data_to_send):
        self.open_pipes();
        try:
            sent_data_length = c_int()
            tx_data_type = c_ubyte * len(data_to_send)
            tx_data = tx_data_type()
            for i in range(len(data_to_send)):
                tx_data[i] = data_to_send[i]
            
            #DWORD _MPUSBWrite(void* handle, void* pData, DWORD dwLen, DWORD* pLength, DWORD dwMilliseconds);
            ret = self.usbDll._MPUSBWrite(self.myOutPipe, tx_data, len(tx_data), byref(sent_data_length), 1000);
        
        finally:        
            self.close_pipes()
        
        return ret
    
    def receive_packet(self, rx_length):
        self.open_pipes();

        try:
            #DWORD _MPUSBRead(void* handle,void* pData,DWORD dwLen,DWORD* pLength,DWORD dwMilliseconds);
            rx_length_act = c_int()
            rx_data_type = c_ubyte * rx_length
            rx_data = rx_data_type()
            ret = self.usbDll._MPUSBRead(self.myInPipe, byref(rx_data), rx_length, byref(rx_length_act), 1000)

            ret_data = []#
            for i in range(rx_length):
                ret_data.append(rx_data[i])
                
        finally:
            self.close_pipes()
            
        for data in rx_data:
            print data
        return (ret, ret_data)

    def easy_command(self, tx_data, rx_length):
        self.send_packet(tx_data)
        return self.receive_packet(rx_length)

if __name__ == '__main__':

    api = USBApi()
    #api.easy_command([4, 0, 10, 2], 1)
    
    
    #Read state
    rx_data = api.easy_command([0], 9)
    print 'Cmd               ' + str(rx_data[1][0])
    print 'State             ' + str(rx_data[1][1])
    print 'Temp              ' +str( rx_data[1][2])
    print 'countdownTime/255 ' + str(rx_data[1][3])
    print 'countdownTime%255 ' + str(rx_data[1][4])
    print 'elapsed_time/255  ' + str(rx_data[1][5])
    print 'elapsed_time%255  ' + str(rx_data[1][6])
    print 'numOfDips         ' + str(rx_data[1][7])
    print 'DipCounter        ' + str(rx_data[1][8])
    
    
   